﻿using AutoMapper;
using HIPS.PcehrSchemas;
using HIPS.Web.UI.ViewModels.PcehrView;

namespace HIPS.Web.UI.Helpers.Mapping.Profiles
{

    /// <summary>
    /// AutoMapper mapping profile for the Document entity.
    /// </summary>
    /// <history>
    ///   <change user="David Sampson (Chamonix)" date="26 November 2013">Initial version.</change>
    /// </history>
    internal class DocumentProfile : Profile
    {

        #region Methods

        /// <summary>
        /// Configures the maps available as part of this mapping profile.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="26 November 2013">Initial version.</change>
        /// </history>
        protected override void Configure()
        {
            //Data --> ViewModel:
            Mapper.CreateMap<DocumentMetaDataItem, DocumentViewModel>()
                .ForMember(dest => dest.Author, opt => opt.MapFrom(src => string.Format("{0}, {1}", src.AuthorPersonFamilyName, src.AuthorPersonGivenName)))
                .ForMember(dest => dest.CreationDate, opt => opt.MapFrom(src => src.CreationTime))
                .ForMember(dest => dest.DocumentId, opt => opt.MapFrom(src => src.DocumentUniqueId))
                .ForMember(dest => dest.CategoryCode, opt => opt.MapFrom(src => src.DocumentClassCode))
                .ForMember(dest => dest.CategoryName, opt => opt.MapFrom(src => src.DocumentClassName))
                .ForMember(dest => dest.Organisation, opt => opt.MapFrom(src => src.AuthorInstitutionName))
                .ForMember(dest => dest.RepositoryId, opt => opt.MapFrom(src => src.RepositoryUniqueId))
                .ForMember(dest => dest.ServiceEndDate, opt => opt.MapFrom(src => src.ServiceStopTime))
                .ForMember(dest => dest.ServiceStartDate, opt => opt.MapFrom(src => src.ServiceStartTime))
                ;
        }

        /// <summary>
        /// Returns the name of the mapping profile.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="26 November 2013">Initial version.</change>
        /// </history>
        public override string ProfileName
        {
            get { return this.GetType().Name; }
        }

        #endregion

    }
}
